/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273.eui;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import ibm.nways.jdm8273.model.AtmxLecModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class LecInfoBasePanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "LAN Emulation Clients";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel AtmxLec_model;
    protected LecSelSection LecSelPropertySection;
    protected LecStatusSection LecStatusPropertySection;
    protected LecOperParmsSection LecOperParmsPropertySection;
    protected ModelInfo LecTableInfo;
    protected ModelInfo AtmxLecDetailsInfo;
    protected int LecTableIndex;
    protected LecTable LecTableData;
    protected TableColumns LecTableColumns;
    protected TableStatus LecTableStatus;
    protected static TableColumn[] LecTableCols = new TableColumn[]{new TableColumn("Index.Slot", "Slot", 3, true), new TableColumn("Index.Port", "Port", 3, true), new TableColumn("Index.ServiceNum", "Service", 3, true), new TableColumn("AtmxLecDetails.AtmxLecInterfaceState", "Oper Status", 16, false), new TableColumn("AtmxLecDetails.AtmxLecActualLanType", "LAN Type", 16, false), new TableColumn("AtmxLecDetails.AtmxLecActualLanName", "LAN Name", 5, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.jdm8273.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm8273.eui.LecInfoBasePanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel LecInfoBase");
        }
    }

    public static String getTitle() {
        LecInfoBasePanel.loadStatics();
        if (myResources != null) {
            title = LecInfoBasePanel.getNLSString("LecInfoBasePanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            LecInfoBasePanel.loadStatics();
        }
        return enumStrings;
    }

    public LecInfoBasePanel() {
        LecInfoBasePanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return LecInfoBasePanel.getTitle();
    }

    protected void getModels() {
        this.AtmxLec_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addLecSelSection();
        this.addLecStatusSection();
        this.addLecOperParmsSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addLecSelSection() {
        this.LecSelPropertySection = new LecSelSection();
        this.LecSelPropertySection.layoutSection();
        this.addSection(LecInfoBasePanel.getNLSString("LecSelSectionTitle"), this.LecSelPropertySection);
    }

    protected void addLecStatusSection() {
        this.LecStatusPropertySection = new LecStatusSection();
        this.LecStatusPropertySection.layoutSection();
        this.addSection(LecInfoBasePanel.getNLSString("LecStatusSectionTitle"), this.LecStatusPropertySection);
    }

    protected void addLecOperParmsSection() {
        this.LecOperParmsPropertySection = new LecOperParmsSection();
        this.LecOperParmsPropertySection.layoutSection();
        this.addSection(LecInfoBasePanel.getNLSString("LecOperParmsSectionTitle"), this.LecOperParmsPropertySection);
    }

    protected void panelRowChange() {
        if (this.LecSelPropertySection != null) {
            this.LecSelPropertySection.rowChange();
        }
        if (this.LecStatusPropertySection != null) {
            this.LecStatusPropertySection.rowChange();
        }
        if (this.LecOperParmsPropertySection != null) {
            this.LecOperParmsPropertySection.rowChange();
        }
    }

    public void filterAtmxLecDetailsInfos(Vector vector) {
    }

    public int getInitialLecTableRow() {
        return 0;
    }

    public ModelInfo initialLecTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(LecInfoBasePanel.getNLSString("startResetMsg"));
        this.LecTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(LecInfoBasePanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(LecInfoBasePanel.getNLSString("endResetMsg")) + " " + LecInfoBasePanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.errorsFound = false;
        this.displayMsg(LecInfoBasePanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.LecTableInfo = (ModelInfo)this.LecTableData.elementAt(this.LecTableIndex);
            this.LecTableInfo = this.LecTableData.setRow();
            this.LecTableData.setElementAt(this.LecTableInfo, this.LecTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(LecInfoBasePanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(LecInfoBasePanel.getNLSString("endApplyMsg")) + " " + LecInfoBasePanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(LecInfoBasePanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.LecTableData = new LecTable();
        this.LecTableIndex = 0;
        this.LecTableColumns = new TableColumns(LecTableCols);
        if (this.AtmxLec_model instanceof RemoteModelWithStatus) {
            try {
                this.LecTableStatus = (TableStatus)this.AtmxLec_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class LecSelSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component LecTableField;
        Label LecTableFieldLabel;
        boolean LecTableFieldWritable = false;

        public LecSelSection() {
            LecInfoBasePanel.this = LecInfoBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createLecTableField() {
            EuiGrid euiGrid = new EuiGrid(LecInfoBasePanel.this.LecTableData, LecInfoBasePanel.this.LecTableColumns, true);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(LecInfoBasePanel.this.initialLecTableRow());
            this.addTable(LecInfoBasePanel.getNLSString("LecTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.LecTableField = this.createLecTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                LecInfoBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("accessDataMsg"));
            LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.LecTableField).refresh();
            LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("endTableGetMsg"));
            LecInfoBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.LecTableField) {
                        LecInfoBasePanel.this.LecTableIndex = euiGridEvent.getRow();
                    }
                    LecInfoBasePanel.this.LecTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.LecTableField).deselectAllRows();
                    LecInfoBasePanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.LecTableField) {
                        LecInfoBasePanel.this.LecTableIndex = 0;
                    }
                    LecInfoBasePanel.this.LecSelPropertySection.reset();
                    LecInfoBasePanel.this.LecStatusPropertySection.reset();
                    LecInfoBasePanel.this.LecOperParmsPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class LecStatusSection
    extends PropertySection {
        ModelInfo chunk;
        Component lecSlotField;
        Component lecPortField;
        Component lecServiceNumField;
        Component lecActualLanNameField;
        Component lecActualLanTypeField;
        Component lecIDField;
        Component lecPrimaryAtmAddressField;
        Component lecInterfaceStateField;
        Component lecLastFailureRespCodeField;
        Component lecLastFailureStateField;
        Label lecSlotFieldLabel;
        Label lecPortFieldLabel;
        Label lecServiceNumFieldLabel;
        Label lecActualLanNameFieldLabel;
        Label lecActualLanTypeFieldLabel;
        Label lecIDFieldLabel;
        Label lecPrimaryAtmAddressFieldLabel;
        Label lecInterfaceStateFieldLabel;
        Label lecLastFailureRespCodeFieldLabel;
        Label lecLastFailureStateFieldLabel;
        boolean lecSlotFieldWritable = false;
        boolean lecPortFieldWritable = false;
        boolean lecServiceNumFieldWritable = false;
        boolean lecActualLanNameFieldWritable = false;
        boolean lecActualLanTypeFieldWritable = false;
        boolean lecIDFieldWritable = false;
        boolean lecPrimaryAtmAddressFieldWritable = false;
        boolean lecInterfaceStateFieldWritable = false;
        boolean lecLastFailureRespCodeFieldWritable = false;
        boolean lecLastFailureStateFieldWritable = false;

        public LecStatusSection() {
            LecInfoBasePanel.this = LecInfoBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createlecSlotField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecSlot.access", "read-only");
            this.lecSlotFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecSlotFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecSlotLabel"), 2);
            if (this.lecSlotFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.lecSlotFieldLabel, (Component)numericInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecSlotFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecSlotField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecSlotField);
            this.validatelecSlotField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecSlotField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecSlotField);
                jDMInput.setValue(object);
                this.validatelecSlotField();
            }
        }

        protected boolean validatelecSlotField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecSlotField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecSlotFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecSlotFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecPortField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecPort.access", "read-only");
            this.lecPortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecPortFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecPortLabel"), 2);
            if (this.lecPortFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.lecPortFieldLabel, (Component)numericInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecPortFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecPortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecPortField);
            this.validatelecPortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecPortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecPortField);
                jDMInput.setValue(object);
                this.validatelecPortField();
            }
        }

        protected boolean validatelecPortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecPortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecPortFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecPortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecServiceNumField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecServiceNum.access", "read-only");
            this.lecServiceNumFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecServiceNumFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecServiceNumLabel"), 2);
            if (this.lecServiceNumFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.lecServiceNumFieldLabel, (Component)numericInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecServiceNumFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecServiceNumField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecServiceNumField);
            this.validatelecServiceNumField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecServiceNumField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecServiceNumField);
                jDMInput.setValue(object);
                this.validatelecServiceNumField();
            }
        }

        protected boolean validatelecServiceNumField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecServiceNumField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecServiceNumFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecServiceNumFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecActualLanNameField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecActualLanName.access", "read-only");
            String string2 = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecActualLanName.length", "32");
            this.lecActualLanNameFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecActualLanNameFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecActualLanNameLabel"), 2);
            if (this.lecActualLanNameFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.lecActualLanNameFieldLabel, (Component)stringInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecActualLanNameFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecActualLanNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecActualLanNameField);
            this.validatelecActualLanNameField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecActualLanNameField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecActualLanNameField);
                jDMInput.setValue(object);
                this.validatelecActualLanNameField();
            }
        }

        protected boolean validatelecActualLanNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecActualLanNameField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecActualLanNameFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecActualLanNameFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecActualLanTypeField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecActualLanType.access", "read-only");
            this.lecActualLanTypeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecActualLanTypeFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecActualLanTypeLabel"), 2);
            if (this.lecActualLanTypeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxLecModel.AtmxLecDetails.AtmxLecActualLanTypeEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecActualLanTypeEnum.numericValues, LecInfoBasePanel.getEnumStrings());
                this.addRow(this.lecActualLanTypeFieldLabel, (Component)singleChoiceInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxLecModel.AtmxLecDetails.AtmxLecActualLanTypeEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecActualLanTypeEnum.numericValues, LecInfoBasePanel.getEnumStrings());
            this.addRow(this.lecActualLanTypeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlecActualLanTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecActualLanTypeField);
            this.validatelecActualLanTypeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecActualLanTypeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecActualLanTypeField);
                jDMInput.setValue(object);
                this.validatelecActualLanTypeField();
            }
        }

        protected boolean validatelecActualLanTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecActualLanTypeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecActualLanTypeFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecActualLanTypeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecIDField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecID.access", "read-only");
            this.lecIDFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecIDFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecIDLabel"), 2);
            if (this.lecIDFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65279);
                this.addRow(this.lecIDFieldLabel, (Component)numericInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecIDFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecIDField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecIDField);
            this.validatelecIDField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecIDField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecIDField);
                jDMInput.setValue(object);
                this.validatelecIDField();
            }
        }

        protected boolean validatelecIDField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecIDField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecIDFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecIDFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecPrimaryAtmAddressField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecPrimaryAtmAddress.access", "read-only");
            LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecPrimaryAtmAddress.length", "1024");
            this.lecPrimaryAtmAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecPrimaryAtmAddressFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecPrimaryAtmAddressLabel"), 2);
            if (this.lecPrimaryAtmAddressFieldWritable) {
                StringInput stringInput = new StringInput();
                this.addRow(this.lecPrimaryAtmAddressFieldLabel, (Component)stringInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecPrimaryAtmAddressFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecPrimaryAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecPrimaryAtmAddressField);
            this.validatelecPrimaryAtmAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecPrimaryAtmAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecPrimaryAtmAddressField);
                jDMInput.setValue(object);
                this.validatelecPrimaryAtmAddressField();
            }
        }

        protected boolean validatelecPrimaryAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecPrimaryAtmAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecPrimaryAtmAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecPrimaryAtmAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecInterfaceStateField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecInterfaceState.access", "read-only");
            this.lecInterfaceStateFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecInterfaceStateFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecInterfaceStateLabel"), 2);
            if (this.lecInterfaceStateFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxLecModel.AtmxLecDetails.AtmxLecInterfaceStateEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecInterfaceStateEnum.numericValues, LecInfoBasePanel.getEnumStrings());
                this.addRow(this.lecInterfaceStateFieldLabel, (Component)singleChoiceInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxLecModel.AtmxLecDetails.AtmxLecInterfaceStateEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecInterfaceStateEnum.numericValues, LecInfoBasePanel.getEnumStrings());
            this.addRow(this.lecInterfaceStateFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlecInterfaceStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecInterfaceStateField);
            this.validatelecInterfaceStateField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecInterfaceStateField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecInterfaceStateField);
                jDMInput.setValue(object);
                this.validatelecInterfaceStateField();
            }
        }

        protected boolean validatelecInterfaceStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecInterfaceStateField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecInterfaceStateFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecInterfaceStateFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecLastFailureRespCodeField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecLastFailureRespCode.access", "read-only");
            this.lecLastFailureRespCodeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecLastFailureRespCodeFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecLastFailureRespCodeLabel"), 2);
            if (this.lecLastFailureRespCodeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxLecModel.AtmxLecDetails.AtmxLecLastFailureRespCodeEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecLastFailureRespCodeEnum.numericValues, LecInfoBasePanel.getEnumStrings());
                this.addRow(this.lecLastFailureRespCodeFieldLabel, (Component)singleChoiceInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxLecModel.AtmxLecDetails.AtmxLecLastFailureRespCodeEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecLastFailureRespCodeEnum.numericValues, LecInfoBasePanel.getEnumStrings());
            this.addRow(this.lecLastFailureRespCodeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlecLastFailureRespCodeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecLastFailureRespCodeField);
            this.validatelecLastFailureRespCodeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecLastFailureRespCodeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecLastFailureRespCodeField);
                jDMInput.setValue(object);
                this.validatelecLastFailureRespCodeField();
            }
        }

        protected boolean validatelecLastFailureRespCodeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecLastFailureRespCodeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecLastFailureRespCodeFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecLastFailureRespCodeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecLastFailureStateField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecLastFailureState.access", "read-only");
            this.lecLastFailureStateFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecLastFailureStateFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecLastFailureStateLabel"), 2);
            if (this.lecLastFailureStateFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxLecModel.AtmxLecDetails.AtmxLecLastFailureStateEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecLastFailureStateEnum.numericValues, LecInfoBasePanel.getEnumStrings());
                this.addRow(this.lecLastFailureStateFieldLabel, (Component)singleChoiceInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxLecModel.AtmxLecDetails.AtmxLecLastFailureStateEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecLastFailureStateEnum.numericValues, LecInfoBasePanel.getEnumStrings());
            this.addRow(this.lecLastFailureStateFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlecLastFailureStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecLastFailureStateField);
            this.validatelecLastFailureStateField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecLastFailureStateField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecLastFailureStateField);
                jDMInput.setValue(object);
                this.validatelecLastFailureStateField();
            }
        }

        protected boolean validatelecLastFailureStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecLastFailureStateField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecLastFailureStateFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecLastFailureStateFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.lecSlotField = this.createlecSlotField();
            this.lecPortField = this.createlecPortField();
            this.lecServiceNumField = this.createlecServiceNumField();
            this.lecActualLanNameField = this.createlecActualLanNameField();
            this.lecActualLanTypeField = this.createlecActualLanTypeField();
            this.lecIDField = this.createlecIDField();
            this.lecPrimaryAtmAddressField = this.createlecPrimaryAtmAddressField();
            this.lecInterfaceStateField = this.createlecInterfaceStateField();
            this.lecLastFailureRespCodeField = this.createlecLastFailureRespCodeField();
            this.lecLastFailureStateField = this.createlecLastFailureStateField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.lecSlotField)).ignoreValue() && this.lecSlotFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecSlot", this.getlecSlotField());
                }
                if (!((JDMInput)((Object)this.lecPortField)).ignoreValue() && this.lecPortFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecPort", this.getlecPortField());
                }
                if (!((JDMInput)((Object)this.lecServiceNumField)).ignoreValue() && this.lecServiceNumFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecServiceNum", this.getlecServiceNumField());
                }
                if (!((JDMInput)((Object)this.lecActualLanNameField)).ignoreValue() && this.lecActualLanNameFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecActualLanName", this.getlecActualLanNameField());
                }
                if (!((JDMInput)((Object)this.lecActualLanTypeField)).ignoreValue() && this.lecActualLanTypeFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecActualLanType", this.getlecActualLanTypeField());
                }
                if (!((JDMInput)((Object)this.lecIDField)).ignoreValue() && this.lecIDFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecID", this.getlecIDField());
                }
                if (!((JDMInput)((Object)this.lecPrimaryAtmAddressField)).ignoreValue() && this.lecPrimaryAtmAddressFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecPrimaryAtmAddress", this.getlecPrimaryAtmAddressField());
                }
                if (!((JDMInput)((Object)this.lecInterfaceStateField)).ignoreValue() && this.lecInterfaceStateFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecInterfaceState", this.getlecInterfaceStateField());
                }
                if (!((JDMInput)((Object)this.lecLastFailureRespCodeField)).ignoreValue() && this.lecLastFailureRespCodeFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecLastFailureRespCode", this.getlecLastFailureRespCodeField());
                }
                if (!((JDMInput)((Object)this.lecLastFailureStateField)).ignoreValue() && this.lecLastFailureStateFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecLastFailureState", this.getlecLastFailureStateField());
                    return;
                }
            } else {
                LecInfoBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setlecSlotField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecSlot", LecInfoBasePanel.this.LecTableIndex));
                this.setlecPortField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecPort", LecInfoBasePanel.this.LecTableIndex));
                this.setlecServiceNumField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecServiceNum", LecInfoBasePanel.this.LecTableIndex));
                this.setlecActualLanNameField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecActualLanName", LecInfoBasePanel.this.LecTableIndex));
                this.setlecActualLanTypeField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecActualLanType", LecInfoBasePanel.this.LecTableIndex));
                this.setlecIDField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecID", LecInfoBasePanel.this.LecTableIndex));
                this.setlecPrimaryAtmAddressField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecPrimaryAtmAddress", LecInfoBasePanel.this.LecTableIndex));
                this.setlecInterfaceStateField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecInterfaceState", LecInfoBasePanel.this.LecTableIndex));
                this.setlecLastFailureRespCodeField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecLastFailureRespCode", LecInfoBasePanel.this.LecTableIndex));
                this.setlecLastFailureStateField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecLastFailureState", LecInfoBasePanel.this.LecTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            LecInfoBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setlecSlotField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecSlot", LecInfoBasePanel.this.LecTableIndex));
            this.setlecPortField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecPort", LecInfoBasePanel.this.LecTableIndex));
            this.setlecServiceNumField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecServiceNum", LecInfoBasePanel.this.LecTableIndex));
            this.setlecActualLanNameField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecActualLanName", LecInfoBasePanel.this.LecTableIndex));
            this.setlecActualLanTypeField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecActualLanType", LecInfoBasePanel.this.LecTableIndex));
            this.setlecIDField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecID", LecInfoBasePanel.this.LecTableIndex));
            this.setlecPrimaryAtmAddressField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecPrimaryAtmAddress", LecInfoBasePanel.this.LecTableIndex));
            this.setlecInterfaceStateField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecInterfaceState", LecInfoBasePanel.this.LecTableIndex));
            this.setlecLastFailureRespCodeField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecLastFailureRespCode", LecInfoBasePanel.this.LecTableIndex));
            this.setlecLastFailureStateField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecLastFailureState", LecInfoBasePanel.this.LecTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }
    }

    public class LecOperParmsSection
    extends PropertySection {
        ModelInfo chunk;
        Component lecConfigSourceField;
        Component lecConfigServerAtmAddressField;
        Component lecActualLesAtmAddressField;
        Component lecProtocolField;
        Component lecVersionField;
        Component lecActualMaxDataFrameSizeField;
        Component lecProxyClientField;
        Component lecTopologyChangeField;
        Label lecConfigSourceFieldLabel;
        Label lecConfigServerAtmAddressFieldLabel;
        Label lecActualLesAtmAddressFieldLabel;
        Label lecProtocolFieldLabel;
        Label lecVersionFieldLabel;
        Label lecActualMaxDataFrameSizeFieldLabel;
        Label lecProxyClientFieldLabel;
        Label lecTopologyChangeFieldLabel;
        boolean lecConfigSourceFieldWritable = false;
        boolean lecConfigServerAtmAddressFieldWritable = false;
        boolean lecActualLesAtmAddressFieldWritable = false;
        boolean lecProtocolFieldWritable = false;
        boolean lecVersionFieldWritable = false;
        boolean lecActualMaxDataFrameSizeFieldWritable = false;
        boolean lecProxyClientFieldWritable = false;
        boolean lecTopologyChangeFieldWritable = false;

        public LecOperParmsSection() {
            LecInfoBasePanel.this = LecInfoBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createlecConfigSourceField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecConfigSource.access", "read-only");
            this.lecConfigSourceFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecConfigSourceFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecConfigSourceLabel"), 2);
            if (this.lecConfigSourceFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxLecModel.AtmxLecDetails.AtmxLecConfigSourceEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecConfigSourceEnum.numericValues, LecInfoBasePanel.getEnumStrings());
                this.addRow(this.lecConfigSourceFieldLabel, (Component)singleChoiceInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxLecModel.AtmxLecDetails.AtmxLecConfigSourceEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecConfigSourceEnum.numericValues, LecInfoBasePanel.getEnumStrings());
            this.addRow(this.lecConfigSourceFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlecConfigSourceField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecConfigSourceField);
            this.validatelecConfigSourceField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecConfigSourceField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecConfigSourceField);
                jDMInput.setValue(object);
                this.validatelecConfigSourceField();
            }
        }

        protected boolean validatelecConfigSourceField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecConfigSourceField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecConfigSourceFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecConfigSourceFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecConfigServerAtmAddressField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecLecsAtmAddress.access", "read-only");
            LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecLecsAtmAddress.length", "1024");
            this.lecConfigServerAtmAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecConfigServerAtmAddressFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecConfigServerAtmAddressLabel"), 2);
            if (this.lecConfigServerAtmAddressFieldWritable) {
                StringInput stringInput = new StringInput();
                this.addRow(this.lecConfigServerAtmAddressFieldLabel, (Component)stringInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecConfigServerAtmAddressFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecConfigServerAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecConfigServerAtmAddressField);
            this.validatelecConfigServerAtmAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecConfigServerAtmAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecConfigServerAtmAddressField);
                jDMInput.setValue(object);
                this.validatelecConfigServerAtmAddressField();
            }
        }

        protected boolean validatelecConfigServerAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecConfigServerAtmAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecConfigServerAtmAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecConfigServerAtmAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecActualLesAtmAddressField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecActualLesAtmAddress.access", "read-only");
            LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecActualLesAtmAddress.length", "1024");
            this.lecActualLesAtmAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecActualLesAtmAddressFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecActualLesAtmAddressLabel"), 2);
            if (this.lecActualLesAtmAddressFieldWritable) {
                StringInput stringInput = new StringInput();
                this.addRow(this.lecActualLesAtmAddressFieldLabel, (Component)stringInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecActualLesAtmAddressFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecActualLesAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecActualLesAtmAddressField);
            this.validatelecActualLesAtmAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecActualLesAtmAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecActualLesAtmAddressField);
                jDMInput.setValue(object);
                this.validatelecActualLesAtmAddressField();
            }
        }

        protected boolean validatelecActualLesAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecActualLesAtmAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecActualLesAtmAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecActualLesAtmAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecProtocolField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecProtocol.access", "read-only");
            this.lecProtocolFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecProtocolFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecProtocolLabel"), 2);
            if (this.lecProtocolFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 255);
                this.addRow(this.lecProtocolFieldLabel, (Component)numericInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecProtocolFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecProtocolField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecProtocolField);
            this.validatelecProtocolField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecProtocolField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecProtocolField);
                jDMInput.setValue(object);
                this.validatelecProtocolField();
            }
        }

        protected boolean validatelecProtocolField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecProtocolField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecProtocolFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecProtocolFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecVersionField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecVersion.access", "read-only");
            this.lecVersionFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecVersionFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecVersionLabel"), 2);
            if (this.lecVersionFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 255);
                this.addRow(this.lecVersionFieldLabel, (Component)numericInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecVersionFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecVersionField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecVersionField);
            this.validatelecVersionField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecVersionField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecVersionField);
                jDMInput.setValue(object);
                this.validatelecVersionField();
            }
        }

        protected boolean validatelecVersionField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecVersionField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecVersionFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecVersionFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecActualMaxDataFrameSizeField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecActualMaxDataFrameSize.access", "read-only");
            this.lecActualMaxDataFrameSizeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecActualMaxDataFrameSizeFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecActualMaxDataFrameSizeLabel"), 2);
            if (this.lecActualMaxDataFrameSizeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxLecModel.AtmxLecDetails.AtmxLecActualMaxDataFrameSizeEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecActualMaxDataFrameSizeEnum.numericValues, LecInfoBasePanel.getEnumStrings());
                this.addRow(this.lecActualMaxDataFrameSizeFieldLabel, (Component)singleChoiceInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxLecModel.AtmxLecDetails.AtmxLecActualMaxDataFrameSizeEnum.symbolicValues, AtmxLecModel.AtmxLecDetails.AtmxLecActualMaxDataFrameSizeEnum.numericValues, LecInfoBasePanel.getEnumStrings());
            this.addRow(this.lecActualMaxDataFrameSizeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlecActualMaxDataFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecActualMaxDataFrameSizeField);
            this.validatelecActualMaxDataFrameSizeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecActualMaxDataFrameSizeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecActualMaxDataFrameSizeField);
                jDMInput.setValue(object);
                this.validatelecActualMaxDataFrameSizeField();
            }
        }

        protected boolean validatelecActualMaxDataFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecActualMaxDataFrameSizeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecActualMaxDataFrameSizeFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecActualMaxDataFrameSizeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecProxyClientField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecProxyClient.access", "read-only");
            this.lecProxyClientFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecProxyClientFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecProxyClientLabel"), 2);
            if (this.lecProxyClientFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.lecProxyClientFieldLabel, (Component)numericInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecProxyClientFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecProxyClientField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecProxyClientField);
            this.validatelecProxyClientField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecProxyClientField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecProxyClientField);
                jDMInput.setValue(object);
                this.validatelecProxyClientField();
            }
        }

        protected boolean validatelecProxyClientField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecProxyClientField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecProxyClientFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecProxyClientFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlecTopologyChangeField() {
            String string = LecInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxLec.AtmxLecDetails.AtmxLecTopologyChange.access", "read-only");
            this.lecTopologyChangeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lecTopologyChangeFieldLabel = new Label(LecInfoBasePanel.getNLSString("lecTopologyChangeLabel"), 2);
            if (this.lecTopologyChangeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.lecTopologyChangeFieldLabel, (Component)numericInput);
                LecInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lecTopologyChangeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlecTopologyChangeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecTopologyChangeField);
            this.validatelecTopologyChangeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlecTopologyChangeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lecTopologyChangeField);
                jDMInput.setValue(object);
                this.validatelecTopologyChangeField();
            }
        }

        protected boolean validatelecTopologyChangeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lecTopologyChangeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lecTopologyChangeFieldLabel.setForeground(Color.yellow);
            } else {
                this.lecTopologyChangeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.lecConfigSourceField = this.createlecConfigSourceField();
            this.lecConfigServerAtmAddressField = this.createlecConfigServerAtmAddressField();
            this.lecActualLesAtmAddressField = this.createlecActualLesAtmAddressField();
            this.lecProtocolField = this.createlecProtocolField();
            this.lecVersionField = this.createlecVersionField();
            this.lecActualMaxDataFrameSizeField = this.createlecActualMaxDataFrameSizeField();
            this.lecProxyClientField = this.createlecProxyClientField();
            this.lecTopologyChangeField = this.createlecTopologyChangeField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.lecConfigSourceField)).ignoreValue() && this.lecConfigSourceFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecConfigSource", this.getlecConfigSourceField());
                }
                if (!((JDMInput)((Object)this.lecConfigServerAtmAddressField)).ignoreValue() && this.lecConfigServerAtmAddressFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecLecsAtmAddress", this.getlecConfigServerAtmAddressField());
                }
                if (!((JDMInput)((Object)this.lecActualLesAtmAddressField)).ignoreValue() && this.lecActualLesAtmAddressFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecActualLesAtmAddress", this.getlecActualLesAtmAddressField());
                }
                if (!((JDMInput)((Object)this.lecProtocolField)).ignoreValue() && this.lecProtocolFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecProtocol", this.getlecProtocolField());
                }
                if (!((JDMInput)((Object)this.lecVersionField)).ignoreValue() && this.lecVersionFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecVersion", this.getlecVersionField());
                }
                if (!((JDMInput)((Object)this.lecActualMaxDataFrameSizeField)).ignoreValue() && this.lecActualMaxDataFrameSizeFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecActualMaxDataFrameSize", this.getlecActualMaxDataFrameSizeField());
                }
                if (!((JDMInput)((Object)this.lecProxyClientField)).ignoreValue() && this.lecProxyClientFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecProxyClient", this.getlecProxyClientField());
                }
                if (!((JDMInput)((Object)this.lecTopologyChangeField)).ignoreValue() && this.lecTopologyChangeFieldWritable) {
                    LecInfoBasePanel.this.AtmxLecDetailsInfo.add("AtmxLecDetails.AtmxLecTopologyChange", this.getlecTopologyChangeField());
                    return;
                }
            } else {
                LecInfoBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setlecConfigSourceField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecConfigSource", LecInfoBasePanel.this.LecTableIndex));
                this.setlecConfigServerAtmAddressField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecLecsAtmAddress", LecInfoBasePanel.this.LecTableIndex));
                this.setlecActualLesAtmAddressField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecActualLesAtmAddress", LecInfoBasePanel.this.LecTableIndex));
                this.setlecProtocolField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecProtocol", LecInfoBasePanel.this.LecTableIndex));
                this.setlecVersionField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecVersion", LecInfoBasePanel.this.LecTableIndex));
                this.setlecActualMaxDataFrameSizeField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecActualMaxDataFrameSize", LecInfoBasePanel.this.LecTableIndex));
                this.setlecProxyClientField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecProxyClient", LecInfoBasePanel.this.LecTableIndex));
                this.setlecTopologyChangeField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecTopologyChange", LecInfoBasePanel.this.LecTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            LecInfoBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setlecConfigSourceField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecConfigSource", LecInfoBasePanel.this.LecTableIndex));
            this.setlecConfigServerAtmAddressField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecLecsAtmAddress", LecInfoBasePanel.this.LecTableIndex));
            this.setlecActualLesAtmAddressField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecActualLesAtmAddress", LecInfoBasePanel.this.LecTableIndex));
            this.setlecProtocolField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecProtocol", LecInfoBasePanel.this.LecTableIndex));
            this.setlecVersionField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecVersion", LecInfoBasePanel.this.LecTableIndex));
            this.setlecActualMaxDataFrameSizeField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecActualMaxDataFrameSize", LecInfoBasePanel.this.LecTableIndex));
            this.setlecProxyClientField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecProxyClient", LecInfoBasePanel.this.LecTableIndex));
            this.setlecTopologyChangeField(LecInfoBasePanel.this.LecTableData.getValueAt("AtmxLecDetails.AtmxLecTopologyChange", LecInfoBasePanel.this.LecTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }
    }

    public class LecTable
    extends Table {
        public ModelInfo setRow() {
            return LecInfoBasePanel.this.LecTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    LecInfoBasePanel.this.LecTableInfo = null;
                    LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("startRow"));
                    LecInfoBasePanel.this.AtmxLecDetailsInfo = LecInfoBasePanel.this.AtmxLec_model.getNextInfo("AtmxLecDetails", "default", modelInfo);
                    LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("endRow"));
                    if (LecInfoBasePanel.this.AtmxLecDetailsInfo != null) {
                        LecInfoBasePanel.this.LecTableInfo = new ModelInfo();
                        if (LecInfoBasePanel.this.AtmxLecDetailsInfo.isBeingMonitored()) {
                            LecInfoBasePanel.this.LecTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = LecInfoBasePanel.this.AtmxLecDetailsInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = LecInfoBasePanel.this.AtmxLecDetailsInfo.get(string);
                            LecInfoBasePanel.this.LecTableInfo.add(string, serializable);
                        }
                    }
                    if (LecInfoBasePanel.this.LecTableInfo != null && !this.validRow(LecInfoBasePanel.this.LecTableInfo)) {
                        modelInfo = LecInfoBasePanel.this.LecTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LecInfoBasePanel.this.LecTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            LecInfoBasePanel.this.LecTableInfo = null;
            try {
                LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("startRow"));
                LecInfoBasePanel.this.AtmxLecDetailsInfo = LecInfoBasePanel.this.AtmxLec_model.getInfo("AtmxLecDetails", "default", modelInfo);
                LecInfoBasePanel.this.displayMsg(LecInfoBasePanel.getNLSString("endRow"));
                if (LecInfoBasePanel.this.AtmxLecDetailsInfo != null) {
                    LecInfoBasePanel.this.LecTableInfo = new ModelInfo();
                    if (LecInfoBasePanel.this.AtmxLecDetailsInfo.isBeingMonitored()) {
                        LecInfoBasePanel.this.LecTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = LecInfoBasePanel.this.AtmxLecDetailsInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = LecInfoBasePanel.this.AtmxLecDetailsInfo.get(string);
                        LecInfoBasePanel.this.LecTableInfo.add(string, serializable);
                    }
                }
                if (LecInfoBasePanel.this.LecTableInfo != null && !this.validRow(LecInfoBasePanel.this.LecTableInfo)) {
                    LecInfoBasePanel.this.LecTableInfo = this.getRow(LecInfoBasePanel.this.LecTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LecInfoBasePanel.this.LecTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (LecInfoBasePanel.this.LecTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            LecInfoBasePanel.this.LecTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        LecInfoBasePanel.this.LecTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        LecInfoBasePanel.this.LecTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    LecInfoBasePanel.this.LecTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            try {
                if (string.equals("AtmxLecDetails.AtmxLecInterfaceState")) {
                    string2 = enumStrings.getString(AtmxLecModel.AtmxLecDetails.AtmxLecInterfaceStateEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            try {
                if (string.equals("AtmxLecDetails.AtmxLecActualLanType")) {
                    string2 = enumStrings.getString(AtmxLecModel.AtmxLecDetails.AtmxLecActualLanTypeEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            return string2;
        }

        public LecTable() {
            LecInfoBasePanel.this = LecInfoBasePanel.this;
        }
    }
}

